<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2022-05-25 03:14
 */
interface BilltemplatedetailDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Billtemplatedetail 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param billtemplatedetail primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Billtemplatedetail billtemplatedetail
 	 */
	public function insert($billtemplatedetail);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Billtemplatedetail billtemplatedetail
 	 */
	public function update($billtemplatedetail);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByBillTemplateId($value);

	public function queryByType($value);

	public function queryByParcode($value);

	public function queryByProductid($value);

	public function queryBySizeid($value);

	public function queryByColorid($value);

	public function queryByUnitid($value);

	public function queryByQuantity($value);


	public function deleteByBillTemplateId($value);

	public function deleteByType($value);

	public function deleteByParcode($value);

	public function deleteByProductid($value);

	public function deleteBySizeid($value);

	public function deleteByColorid($value);

	public function deleteByUnitid($value);

	public function deleteByQuantity($value);


}
?>